/* l100n 1.0 - unusual JavaScript library for pure client-side localization by css-selectors
 * Full description in Russian: http://vas3k.ru/dev/l100n
 * Licensed under the LGPL licenses:
 *   http://www.gnu.org/licenses/lgpl.html
 */
l100n = {
locale: get_cookie_locale(), default_locale: "en", always_localize: [],
pages: {
"main": {              // Page codename
    "title": {selector: "title", en: "KSE Device User Page", ru: "KSE Device Страница пользователя"},
    "autoupdate": { selector: "#autoupdate", en: "Autoupdate", ru: "Автообновление"},
    //"language": { selector: "#language", en: "en", ru: "рус"},
    "access_control": { selector: "#access_control", en: "Access control:", ru: "Уровень доступа:"},
    "Device Description": {selector: "#Device_Description", en: "Device Description", ru: "Общие параметры"},
    "time": {selector: "#time", en: "Date and Time ", ru: "Дата и время "},
    "uid": {selector: "#uid", en: "UID ", ru: "UID "},
    "interface_language": {selector: "#interface_language", en: "Interface language ", ru: "Язык интерфейса "},
    "sw_version": {selector: "#sw_version", en: "SW version ", ru: "Версия системного ПО "},
    "battery_voltage": {selector: "#battery_voltage", en: "Battery voltage, V ", ru: "Напряжение батареи, В "},
    "command": {selector: "#command", en: "Command ", ru: "Команда "},
    "password": {selector: "#password", en: "Password ", ru: "Пароль "},
    "restore_default_settings": {selector: "#restore_default_settings", en: "Restore Default Settings ", ru: "Востановить настройки по умолчанию "},
    "Boards_Types": {selector: "#Boards_Types", en: "Modules Types", ru: "Типы модулей"},
    "main_board": {selector: "#main_board", en: "Main Module ", ru: "Базовый модуль "},
    "board_0": {selector: "#board_module_0", en: "Extention Module 0 ", ru: "Модуль расширения 0 "},
    "board_1": {selector: "#board_module_1", en: "Extention Module 1 ", ru: "Модуль расширения 1 "},
    "board_2": {selector: "#board_module_2", en: "Extention Module 2 ", ru: "Модуль расширения 2 "},
    "board_3": {selector: "#board_module_3", en: "Extention Module 3 ", ru: "Модуль расширения 3 "},
    "board_4": {selector: "#board_module_4", en: "Extention Module 4 ", ru: "Модуль расширения 4 "},
    "board_5": {selector: "#board_module_5", en: "Extention Module 5 ", ru: "Модуль расширения 5 "},
    "board_6": {selector: "#board_module_6", en: "Extention Module 6 ", ru: "Модуль расширения 6 "},
    "board_7": {selector: "#board_module_7", en: "Extention Module 7 ", ru: "Модуль расширения 7 "},
    "board_8": {selector: "#board_module_8", en: "Extention Module 8 ", ru: "Модуль расширения 8 "},
    "Network Settings": {selector: "#Network_Settings", en: "Network Settings", ru: "Настройки сети"},
    "rs_enable": {selector: "#rs_enable", en: "Enable ", ru: "Задействовать "},
    "rs_data_rate": {selector: "#rs_data_rate", en: "Data rate, kbit/s ", ru: "Скорость передачи, кбит/с "},
    "rs_parity": {selector: "#rs_parity", en: "Parity ", ru: "Четность "},
    "rs_stop_bits": {selector: "#rs_stop_bits", en: "Stop bits ", ru: "Стоп биты "},
    "rs_modbus_settings": {selector: "#rs_modbus_settings", en: "Modbus settings ", ru: "Modbus "},
    "rs_device_address": {selector: "#rs_device_address", en: "Device address ", ru: "Адрес устройства "},
    "rs_answer_delay": {selector: "#rs_answer_delay", en: "Answer Delay, ms ", ru: "Задержка ответа, мс "},
    "rs_poll_timeout": {selector: "#rs_poll_timeout", en: "Poll Timeout, s ", ru: "Время ожидания опроса, с "},
    "ethernet_ip_address": {selector: "#ethernet_ip_address", en: "IP Address ", ru: "IP адрес "},
    "ethernet_net_mask": {selector: "#ethernet_net_mask", en: "Net Mask ", ru: "Маска сети "},
    "ethernet_gateway": {selector: "#ethernet_gateway", en: "Gateway ", ru: "Шлюз "},
    "ethernet_dns1": {selector: "#ethernet_dns1", en: "DNS 1 ", ru: "DNS 1 "},
    "ethernet_dns2": {selector: "#ethernet_dns2", en: "DNS 2 ", ru: "DNS 2 "},
    "ethernet_dhcp_enable": {selector: "#ethernet_dhcp_enable", en: "DHCP Enable ", ru: "DHCP "},
    "can_enable": {selector: "#can_enable", en: "Enable: ", ru: "Задействовать: "},
    "can_data_rate": {selector: "#can_data_rate", en: "Data rate, kbit/s ", ru: "Скорость передачи, кбит/с "},
    "can_settings": {selector: "#can_settings", en: "CANopen settings ", ru: "CANopen "},
    "node_id": {selector: "#node_id", en: "Node id", ru: "Node id"},
    "node_1": {selector: "#node_1", en: "Node id 1 ", ru: "Node id 1 "},
    "node_2": {selector: "#node_2", en: "Node id 2 ", ru: "Node id 2 "},
    "node_3": {selector: "#node_3", en: "Node id 3 ", ru: "Node id 3 "},
    "node_4": {selector: "#node_4", en: "Node id 4 ", ru: "Node id 4 "},
    "node_5": {selector: "#node_5", en: "Node id 5 ", ru: "Node id 5 "},
    "node_6": {selector: "#node_6", en: "Node id 6 ", ru: "Node id 6 "},
    "node_7": {selector: "#node_7", en: "Node id 7 ", ru: "Node id 7 "},
    "node_8": {selector: "#node_8", en: "Node id 8 ", ru: "Node id 8 "},
    "Boards_Settings": {selector: "#Boards_Settings", en: "I/O Modules Settings", ru: "Настройки модулей расширения"},
    "Heating_Lines": {selector: "#Heating_Lines", en: "Heating Lines", ru: "Линии обогрева"},
    "Heating": {selector: "#Heating", en: "Heating", ru: "Обогрев"},
    "Product_Code": {selector: "#Product_Code", en: "Product Code ", ru: "Код устройства "},
    "App_version": {selector: "#App_version", en: "App version ", ru: "Версия прикладного ПО "},
    "index_error": {en: "Index error", ru: "Ошибка индекса"},
}, "ui": {
    "apply_button": {en: "apply", ru: "Применить"},
    "show_password": {en: "show password", ru: "показать пароль"},
    "validator_pass": {en: "4 digits", ru: "4 цифры"},
    "ip_address_pass": {en: "octet number must be between [0-255]", ru: "Четыре числа в интервале [0-255]"},
    "response error": {en: "Error in response from server.", ru: "Ошибка в ответе с сервера."},
    "ACCESS DENIED": {en: "ACCESS DENIED", ru: "Ошибка доступа"},
    "ACCESS CONFIRMED": {en: "ACCESS CONFIRMED", ru: "Доступ разрешен"},
    "Invalid data format.": {en: "Invalid data format.", ru: "Неверный формат данных"},
    "Check device connection...": {en: "Check device connection...", ru: "Проверьте соединение с контроллером..."},
    "Passwords are different.": {en: "Passwords are different.", ru: "Пароли не совпадают."},
    "Password are changed.": {en: "Password are changed.", ru: "Пароль изменен."},
    "Change password.": {en: "Change password", ru: "Смена пароля"},
    "Ok": {en: "OK", ru: "Применить"},
    "Cancel": {en: "Cancel", ru: "Отмена"},
    "hex_dec_number": {en: "Hex or Dec number", ru: "Число в шестнадцетиричном или десятичном формате."},
    "range_localization": {en: "Please enter a value in interval ", ru: "Введите число в интервале "},
    "Login": {en: "Login", ru: "Вход"},
    "Expert_page": {selector: "#Expert_page", en: "Expert page", ru: "Расширенные настройки"},
    "modbus_mapping_page": {en: "Modbus mappings", ru: "Cловарь Modbus"},
    "Login_header": {en: "Please enter password", ru: "Требуется ввод пароля"},
    "Set datetime manually": {en: "Set Manually", ru: "Установить вручную"},
    "Synchronize": {en: "Set from PC", ru: "Принять время ПК"},
    "Restart and reload": {en: "Restart device and reload web page", ru: "Перезагрузите устройство и обновите страницу"},
},"configuration": {
    "access_control_on": {en: "Access Control On", ru: "Включить контроль доступа"},
    "access_control_off": {en: "Access Control Off", ru: "Отключить контроль доступа"},
    "off": {en: "Off", ru: "выкл"},
    "on": {en: "On", ru: "вкл"},
    "yes": {en: "True", ru: "да"},
    "no": {en: "False", ru: "нет"},
    "user": {en: "User", ru: "пользователь"},
    "admin": {en: "Admin", ru: "администратор"},
    "even": {en: "Even", ru: "четный"},
    "odd": {en: "Odd", ru: "нечетный"},
    "access_level_reset": {en: "Access Level Reset", ru: "Сбросить уровень доступа"},
    "change_password": {en: "Change Password", ru: "Сменить пароль доступа"},
    "counter_reset": {en: "Counter Reset", ru: "Сброс накопления счетчиков"},
    "download_settings": {en: "Download Settings", ru: "Скачать настройки"},
    "upload_settings": {en: "Upload Settings", ru: "Записать настройки"},
    "reboot": {en: "Reboot", ru: "Перезагрузка"},
    "dummy": {en: "0 - Dummy", ru: "0 - Резерв"},
    "slot_absent": {en: "Slot absent", ru: "Отсутствует слот"},
    "channel": {en: "Channel", ru: "Канал"},
    "9.6": {en: "9.6", ru: "9,6"},
	"19.2": {en: "19.2", ru: "19,2"},
	"38.4": {en: "38.4", ru: "38,4"},
	"57.6": {en: "57.6", ru: "57,6"},
    "115.2": {en: "115.2", ru: "115,2"},
    "500µA": {en: "0.5mA", ru: "0,5мА"},
    "125µA": {en: "0.125mA", ru: "0,125мА"},
    "H-5A/L-0,1A": {en: "H-5A/L-0.1A", ru: "H-5A/L-0,1A"},
    "H-1,25A/L-0,025A": {en: "H-1.25A/L-0.025A", ru: "H-1,25A/L-0,025A"},
    "ua_absent": {en: "Absent", ru: "отсутствует"},
    "ua_start": {en: "Start", ru: "старт"},
    "ua_stop": {en: "Stop", ru: "стоп"},
},"MDR_configuration": {
    "Heater Off": {en: "Heater Off", ru: "Нагрев выкл"},
    "Heater On": {en: "Heater On", ru: "Нагрев вкл"},
    "Remote": {en: "Remote", ru: "Дистанционный"},
    "error_status": {en: "ERROR", ru: "ОШИБКА"},
    "First": {en: "First", ru: "Первый"},
    "Second": {en: "Second", ru: "Второй"},
    "Average": {en: "Average", ru: "Среднее"},
    "Min": {en: "Min", ru: "Мин"},
    "Max": {en: "Max", ru: "Макс"},
    "Running Hours Reset": {en: "Running Hours Reset", ru: "Сброс моточасов"},
    "Switch On Counter Reset": {en: "Switch On Counter Reset", ru: "Включить сброс счетчиков"},
    "Discret I/O": {en: "Discret I/O", ru: "Дискретные вх/вых"},
    "Analog Inputs": {en: "Analog Inputs", ru: "Аналоговые входы"},
} ,"user_page": {
    "module": {en: "Module", ru: "Модуль"},
    "value": {en: "Value ", ru: "Значение "},
    "invert_polarity": {en: "Invert polarity ", ru: "Смена полярности "},
    "Filter time": {en: "Filter time", ru: "Время фильтрации"},
    "Input Sensor": {en: "Sensor Type", ru: "Тип датчика"},
    "Filter time, ms": {en: "Filter time, ms ", ru: "Время фильтрации, мс "},
    "Error mode": {en: "Error mode ", ru: "Режим безопасности "},
    "Error value": {en: "Error value ", ru: "Безопасное состояние "},
    "Filter mask": {en: "Filter mask ", ru: "Маскирование управления "},
    "Channel:": {en: "Channel ", ru: "Канал "},
    "Scaling": {en: "Scaling ", ru: "Масштабирование "},
    "Offset": {en: "Offset ", ru: "Смещение "},
    "Deadband Reference": {en: "Deadband Reference ", ru: "Диапазон "},
    "Deadband, %": {en: "Deadband, % ", ru: "Зона нечувствительности, % "},
    "Settings": {en: "Settings", ru: "Настройки"},
    "Scheme": {en: "Scheme ", ru: "Схема "},
    "Current range": {en: "Current range Ia,Ib,Ic ", ru: "Диапазон тока Ia,Ib,Ic"},
    "Current range Lkg": {en: "Current range Id ", ru: "Диапазон тока Id "},
    "CTR": {en: "CTR Ia,Ib,Ic ", ru: "CTR Ia,Ib,Ic "},
    "CTR Lkg": {en: "CTR Id ", ru: "CTR Id "},
    "VTR": {en: "VTR ", ru: "VTR "},
    "Deadband Settings": {en: "Deadband", ru: "Зоны нечувствительности"},
    "C V PF": {en: "Current, Voltage, PF", ru: "Ток, напряжение, КМ"},
    "Power": {en: "Power", ru: "Мощность"},
    "Quality": {en: "Quality", ru: "Качество"},
    "Energy": {en: "Energy", ru: "Энергия"},
    "Statistics": {en: "Misc", ru: "Разное"},
    "Upper Limit": {en: "Upper Limit", ru: "Верхний предел"},
    "Lower Limit": {en: "Lower Limit", ru: "Нижний предел"},
    "ext_Settings": {en: "Sensor Select", ru: "Выбор датчика"},
    "AI Read Float": {en: "AI Read Float", ru: "Значение аналогов"},
    "not selected": {en: "Not Selected", ru: "Не выбран"},
    "ext_Channel": {en: "Channel", ru: "Канал"},
    "ext_Channels_header": {en: "External I/O Settings", ru: "Настройки внешних вводов/выводов"},
    "1 Wire accordion header": {en: "1-Wire Sensors", ru: "Датчики 1-Wire"},
    "Operating Hours": {en: "Operating Hours", ru: "Моточасы фазы"},
    "Total Operating Hours": {en: "Total Operating Hours", ru: "Общие моточасы"},
    "Current": {en: "Current", ru: "Токи"},
    "L2N Voltage": {en: "Line-to-Neutral Voltage", ru: "Фазное напряжение"},
    "L2L Voltage": {en: "Line-to-Line Voltage", ru: "Линейное напряжение"},
    "Power Factor": {en: "Power Factor", ru: "Коэффициент мощности"},
    "Active": {en: "Active", ru: "Активная"},
    "Reactive": {en: "Reactive", ru: "Реактивная"},
    "Apparent": {en: "Apparent", ru: "Суммарная"},
    "Pulse Qty": {en: "Pulse Qty", ru: "Вес разряда"},
    "Frequency": {en: "Frequency", ru: "Частота"},
    "THD Current": {en: "THD Current", ru: "КНИ тока"},
    "THD Voltage": {en: "THD Voltage", ru: "КНИ напряжения"},
    "Current ranges": {en: "Input ranges", ru: "Диапазоны тока"},
    "Transformation ratios": {en: "Transformation ratios", ru: "Коэффициенты трансформации"},
    "state": {en: "State", ru: "Состояние"},
    "input state": {en: "Input", ru: "Вход"},
    "output state": {en: "Output", ru: "Выход"},
    "Symmetrical components": {en: "Symmetrical components", ru: "Симметричные компоненты"},
    "Alarm relay": {en: "Alarm relay", ru: "Аварийное реле"},
} ,"units": {
    "V": {en: "V", ru: "В"},
    "kW": {en: "kW", ru: "кВт"},
    "kvar": {en: "kvar", ru: "квар"},
    "kVA": {en: "kVA", ru: "кВА"},
    "kWh": {en: "kWh", ru: "кВтч"},
    "kvarh": {en: "kvarh", ru: "кварч"},
    "kVAh": {en: "kVAh", ru: "кВАч"},
    "Hz": {en: "Hz", ru: "Гц"},
    "mA": {en: "mA", ru: "мА"},
    "kW/h": {en: "kW/h", ru: "КВт/ч"},
    "ms": {en: "ms", ru: "мс"},
} ,"heating lines": {
    "Line": {en: "Line", ru: "Линия"},
    "Live View": {en: "Live View", ru: "Текущие параметры"},
    "Alarms": {en: "Alarms", ru: "Аварийные сигналы"},
    "Alarm Settings": {en: "Alarm Settings", ru: "Настройка пределов"},
    "HW Settings": {en: "HW Settings", ru: "Настройки вх/вых"},
    "Control": {en: "Control", ru: "Управление"},
    "Name": {en: "Name", ru: "Название"},
    "Alarm Present": {en: "Alarm Present", ru: "Присутствует авария"},
    "Actual Control Mode": {en: "Actual Control Mode", ru: "Текущий режим управления"},
    "Safe Mode": {en: "Safe Mode", ru: "Безопасный режим"},
    "Output State": {en: "Output State", ru: "Состояние выхода"},
    "Contactor State": {en: "Contactor State", ru: "Состояние контактора"},
    "Trip Reset": {en: "Trip Reset", ru: "Сброс отключения"},
    "Remote Output": {en: "Remote Output", ru: "Дистанционное управление"},
    "Temperature PV": {en: "Temperature PV", ru: "Значения температуры"},
    "Process Temperature": {en: "Process Temperature, °C", ru: "Расчетная температура, °C"},
    "Temperature 1": {en: "Temperature 1, °C", ru: "Температура 1, °C"},
    "Temperature 2": {en: "Temperature 2, °C", ru: "Температура 2, °C"},
    "Temperature 1 Input": {en: "Temperature 1 Input", ru: "Вход датчика температуры 1"},
    "Temperature 2 Input": {en: "Temperature 2 Input", ru: "Вход датчика температуры 2"},
    "Current PV": {en: "Current PV", ru: "Значения тока"},
    "Load Current": {en: "Load Current, A", ru: "Ток нагрузки, А"},
    "Leakage Current": {en: "Leakage Current, mA", ru: "Ток утечки, мА"},
    "Misc PV": {en: "Misc PV", ru: "Прочие значения"},
    "PWM Val": {en: "PWM Val, %", ru: "ШИМ, %"},
    "Output On Count": {en: "Output On Count", ru: "Счётчик включений"},
    "Running Hours": {en: "Running Hours, h", ru: "Моточасы, ч"},
    "Temperature Alarms": {en: "Temperature Alarms", ru: "Аварии температуры"},
    "Alarm": {en: "Alarm", ru: "Авария"}, "Trip": {en: "Trip", ru: "Защита"},
    "Process Temperature Fault": {en: "Process Temperature Fault", ru: "Ошибка расчёта температуры процесса"},
    "Temperature 1 Fault": {en: "Temperature 1 Fault", ru: "Температура 1 отказ"},
    "Temperature 1 High": {en: "Temperature 1 High", ru: "Температура 1 верхний предел"},
    "Temperature 1 Low": {en: "Temperature 1 Low", ru: "Температура 1 нижний предел"},
    "Temperature 2 Fault": {en: "Temperature 2 Fault", ru: "Температура 2 отказ"},
    "Temperature 2 High": {en: "Temperature 2 High", ru: "Температура 2 верхний предел"},
    "Temperature 2 Low": {en: "Temperature 2 Low", ru: "Температура 2 нижний предел"},
    "Current Alarms": {en: "Current Alarms", ru: "Аварии токов"},
    "Load Current High": {en: "Load Current High", ru: "Ток нагрузки верхний предел"},
    "Load Current Low": {en: "Load Current Low", ru: "Ток нагрузки нижний предел"},
    "Leakage Current High": {en: "Leakage Current High", ru: "Ток утечки верхний предел"},
    "Output Off Current High": {en: "Output Off Current High", ru: "Ток при отключенной нагрузке верхний предел"},
    "Misc Alarms": {en: "Misc Alarms", ru: "Прочие аварии"},
    "Misconfig": {en: "Misconfig", ru: "Неправильная конфигурация"},
    "Circuitbreaker OF": {en: "Circuitbreaker OF", ru: "Автомат отключен"},
    "Circuitbreaker SD": {en: "Circuitbreaker SD", ru: "Аварийное отключение автомата"},
    "Contactor Fault": {en: "Contactor Fault", ru: "Отказ контактора"},
    "Temperature Trips Enable": {en: "Temperature Trips Enable", ru: "Разрешить отключение по температуре"},
    "Current Trips Enable": {en: "Current Trips Enable", ru: "Разрешить отключение по току"},
    "Temperature Alarm Settings": {en: "Temperature Alarm Settings", ru: "Уставка температуры"},
    "Temperature High": {en: "Temperature High, °C", ru: "Температура верхний предел, °C"},
    "Temperature Low": {en: "Temperature Low, °C", ru: "Температура нижний предел, °C"},
    "Current Alarm Settings": {en: "Current Alarm Settings", ru: "Уставка тока"},
    "Misc Alarm Settings": {en: "Misc Alarm Settings", ru: "Прочие настройки аварийных пределов"},
    "Alarm Hold Time": {en: "Alarm Hold Time, s", ru: "Минимальное время удержания флагов аварий, с"},
    "alarm_enable": {en: "Enable", ru: "Ввод линии в работу"},
    "Startup Delay": {en: "Startup Delay, s", ru: "Задержка первого включения, c"},
    "Control Mode": {en: "Control Mode", ru: "Режим управления"},
    "Safe Mode": {en: "Safe Mode", ru: "Безопасный режим"},
    "PWM": {en: "PWM", ru: "ШИМ"},
    "PWM Period": {en: "PWM Period", ru: "Период ШИМ"},
    "PWM Duty Cycle": {en: "PWM Duty Cycle, %", ru: "Рабочий цикл ШИМ, %"},
    "Temp Relay": {en: "Thermal Relay", ru: "Режим термостата"},
    "Process Temperature Calc Mode": {en: "Process Temperature Calc Mode", ru: "Режим расчета температуры процесса"},
    "Allow Incomplete Sensors": {en: "Allow Incomplete Sensors", ru: "Разрешение работы при отказе одного датчика"},
    "Process Temp Set-point": {en: "Process Temp Set-point, °C", ru: "Уставка температуры"},
    "Hysteresis Positive": {en: "Hysteresis Positive, °C", ru: "Гистерезис положительный, °C"},
    "Hysteresis Negative": {en: "Hysteresis Negative, °C", ru: "Гистерезис отрицательный, °C"},
    "PWM Proportional": {en: "PWM Proportional", ru: "Пропорциональный режим"},
    "Proportional High Temp": {en: "Proportional High Temp, °C", ru: "Верхняя граница температуры, °C"},
    "Proportional High PWM Duty Cycle": {en: "Proportional High PWM Duty Cycle, %", ru: "Рабочий цикл для верхней границы, %"},
    "Proportional Low Temp": {en: "Proportional Low Temp, °C", ru: "Нижняя граница температуры, °C"},
    "Proportional Low PWM Duty Cycle": {en: "Proportional Low PWM Duty Cycle, %", ru: "Рабочий цикл для нижней границы, %"},
    "HL DeadBand Settings": {en: "DeadBand Settings", ru: "Настройка зон нечувствительности"},
    "Temperature Deadband Reference": {en: "Temperature Deadband Reference, °C", ru: "Опорный диапазон нечувствительности по температуре, °C"},
    "Temperature Deadband": {en: "Temperature Deadband, %", ru: "Зона нечувствительности по температуре, %"},
    "Current Deadband Reference": {en: "Current Deadband Reference, A", ru: "Опорный диапазон нечувствительности по току нагрузки, А"},
    "Current Deadband": {en: "Current Deadband, %", ru: "Зона нечувствительности по току нагрузки, %"},
    "Leakage Current Deadband Reference": {en: "Leakage Current Deadband Reference, mA", ru: "Опорный диапазон нечувствительности по току утечки, мА"},
    "Leakage Current Deadband": {en: "Leakage Current Deadband, %", ru: "Зона нечувствительности по току утечки, %"},
    "Minimum Output Hold Time": {en: "Minimum Output Hold Time, s", ru: "Минимальное время удержания выхода, с"},
    "Output Select": {en: "Output Select", ru: "Выбор выхода"},
    "Input Select": {en: "Input Select", ru: "Выбор входа"},
    "Heatline_Control": {en: "Control", ru: "Управление"},
    "Heatline_Command": {en: "Command", ru: "Команда"},
    "Remote Output Control": {en: "Remote Output Control", ru: "Удаленное управление выходом"},
    "Temperature 1 Sensor Type": {en: "Temperature 1 Sensor Type", ru: "Тип датчика TI1"},
    "Temperature 2 Sensor Type": {en: "Temperature 2 Sensor Type", ru: "Тип датчика TI2"},
    "Load Current Filter Time": {en: "Load Current Filter Time, ms", ru: "Время фильтрации тока нагрузки, мс"},
    "Leakage Current Filter Time": {en: "Leakage Current Filter Time, ms", ru: "Время фильтрации тока утечки, мс"},
    "Heatline_Settings": {en: "Settings", ru: "Настройки линии"},
    "Heating Line": {en: "Heating Line", ru: "Линия обогрева"},
} ,"reports": {
    "Current_report": {selector: "#Current_report", en: "Report status: ", ru: "Статус отчета "},
    "Start": {selector: "#Start", en: "Start", ru: "Начало"},
    "Stop": {selector: "#Stop", en: "Stop", ru: "Конец"},
    "Current_time": {selector: "#Current_time", en: "Current", ru: "Текущее"},
    "Wap": {selector: "#Wap", en: "Wa+", ru: "Wa-"},
    "Wbp": {selector: "#Wbp", en: "Wb+", ru: "Wb-"},
    "Wcp": {selector: "#Wcp", en: "Wc+", ru: "Wc-"},
    "Wan": {selector: "#Wan", en: "Wa-", ru: "Wa-"},
    "Wbn": {selector: "#Wbn", en: "Wb-", ru: "Wb-"},
    "Wcn": {selector: "#Wcn", en: "Wc-", ru: "Wc-"},
    "WQap": {selector: "#WQap", en: "WQa+", ru: "WQa+"},
    "WQbp": {selector: "#WQbp", en: "WQb+", ru: "WQb+"},
    "WQcp": {selector: "#WQcp", en: "WQc+", ru: "WQc+"},
    "WQan": {selector: "#WQan", en: "WQa-", ru: "WQa-"},
    "WQbn": {selector: "#WQbn", en: "WQb-", ru: "WQb-"},
    "WQcn": {selector: "#WQcn", en: "WQc-", ru: "WQc-"},
    "Pap": {selector: "#Pap", en: "Pa+", ru: "Pa+"},
    "Pbp": {selector: "#Pbp", en: "Pb+", ru: "Pb+"},
    "Pcp": {selector: "#Pcp", en: "Pc+", ru: "Pc+"},
    "Pan": {selector: "#Pan", en: "Pa-", ru: "Pa-"},
    "Pbn": {selector: "#Pbn", en: "Pb-", ru: "Pb-"},
    "Pcn": {selector: "#Pcn", en: "Pc-", ru: "Pc-"},
    "Qap": {selector: "#Qap", en: "Qa+", ru: "Qa+"},
    "Qbp": {selector: "#Qbp", en: "Qb+", ru: "Qb+"},
    "Qcp": {selector: "#Qcp", en: "Qc+", ru: "Qc+"},
    "Qan": {selector: "#Qan", en: "Qa-", ru: "Qa-"},
    "Qbn": {selector: "#Qbn", en: "Qb-", ru: "Qb-"},
    "Qcn": {selector: "#Qcn", en: "Qc-", ru: "Qc-"},
    "Enable": {selector: "#Enable", en: "Enable ", ru: "Задействовать "},
    "Control": {selector: "#Control", en: "Control ", ru: "Управление "},
    "Period": {selector: "#Period", en: "Period, min ", ru: "Период, мин "},
    "Request_Report_Time": {selector: "#Request_Report_Time", en: "Request Report Date ", ru: "Дата запрашиваемого отчета "},
    "send_reports_request": {en: "Request report", ru: "Запросить отчет"},
    "COMMAND_CLEAR_ENERGY": {en: "Reset values", ru: "Сбросить счетчики"},
    "COMMAND_CLEAR_ENERGY_confirm_question": {en: "Are you sure you want to reset energy values?", ru: "Вы уверены, что хотите сбросить счетчики энергии?"},
    "COMMAND_CLEAR_MTHRS": {en: "Reset values", ru: "Сбросить счетчики"},
    "COMMAND_CLEAR_MTHRS_confirm_question": {en: "Are you sure you want to reset operating hours?", ru: "Вы уверены, что хотите сбросить счетчики моточасов?"},
    "set system time": {en: "Set system time", ru: "Установить системное время"},
    "system_time_setting_confirm_question": {en: "Are you sure you want to set system time on device?", ru: "Вы уверены, что хотите установить на устройство системное время?"},
    "Reports_table": {selector: "#Reports_table", en: "Reports table", ru: "Таблица значений"},
    //"Chart_name": {selector: "#Chart_name", en: "Chart", ru: "График"},
    "No data": {en: "No data", ru: "Нет данных за данный период"},
    "Device off": {en: "No data", ru: "Нет данных"},
    "P+": {en: "Power active positive", ru: "Мощность активная прямая"},
    "P-": {en: "Power active negative", ru: "Мощность активная обратная"},
    "Q+": {en: "Power reactive positive", ru: "Мощность реактивная прямая"},
    "Q-": {en: "Power reactive negative", ru: "Мощность реактивная обратная"},
    "power_sum": {en: "Total Power", ru: "Суммарная мощность"},
    "W+": {en: "Energy Real Positive", ru: "Энергия активная прямая"},
    "W-": {en: "Energy Real Negative", ru: "Энергия активная обратная"},
    "WQ+": {en: "Energy Reactive Positive", ru: "Энергия реактивная прямая"},
    "WQ-": {en: "Energy Reactive Negative", ru: "Энергия реактивная обратная"},
    "total_energy": {en: "Apparent Energy", ru: "Суммарная энергия"},
} ,"modbus mappings": {
    "Registr": {en: "Register", ru: "Регистр"},
    "AccessType": {en: "Access Type", ru: "Тип доступа"},
    "Comment": {en: "Comment", ru: "Комментарий"},
    "DataType": {en: "Data Type", ru: "Тип данных"},
    "Eds Index": {en: "EDS Index", ru: "Индекс EDS"},
    "double_registr_misstake": {en: "Modbus mapping mistake: register number was specified several times.", ru: "Ошибка в modbus mapping: регистр указан несколько раз."},
}},



/**
 * Returns user browser locale (two-digits code)
 */
get_browser_locale : function() {
    return (navigator.language || navigator.systemLanguage || navigator.browserLanguage || navigator.userLanguage || this.default_locale).substr(0, 2).toLowerCase();
},

/**
 * Add page localizationn dictionary to localization object
 * @param page_name (required) - page codename
 * @param page_strings (optional) - l10n dictionary
 */
add_page: function(page_name, page_strings) {
    if (page_name) {
        this.pages[page_name] = page_strings;
        return true;
    }
    return false;
},

/**
 * Localize element by codename
 * @param name (required) - string codename
 * @param custom_page (optional) - page codename, if not provided causes full scan for string codename
 * @param custom_locale (optional) - custom locale codename
 */
localize: function(name, custom_page, custom_locale) {
    var loc = custom_locale || this.locale || this.default_locale;

    var l10n_object = this.get_l10n_object(name, custom_page);
    if (!l10n_object) return false;

    // Try to get localization
    var l10n_string = l10n_object[loc];
    if (!l10n_string) {
        // In case of failure, try to get default localization
        l10n_string = l10n_object[this.default_locale];
        // If not default localization - fail
        if (!l10n_string) return false;
    }

    // Localizing element
    $(l10n_object.selector).html(l10n_string);
    return true;
},

/**
 * Returns localized string for codename
 * @param name (required) - string codename
 * @param custom_page (optional) - page codename, if not provided causes full scan for string codename
 * @param custom_locale (optional) - custom locale codename
 */
localize_string: function(name, custom_page, custom_locale) {
    var loc = custom_locale || this.locale || this.default_locale;

    var l10n_object = this.get_l10n_object(name, custom_page);
    if (!l10n_object) return "";

    // Try to get localization
    var l10n_string = l10n_object[loc];
    if (!l10n_string) {
        // In case of failure, try to get default localization
        l10n_string = l10n_object[this.default_locale];
        // If not default localization - fail
        if (!l10n_string) return "";
    }

    // Returns localized string
    return l10n_string;
},

/**
 * Localize entire page by page codename
 * @param page (required) - page codename
 * @param custom_locale (optional) - custom locale codename
 * @param no_always (optional) - if true, ignore always_localize pages
 */
localize_page: function(page, custom_locale, no_always) {
    if (!page) return false;
    var loc = custom_locale || this.locale || this.default_locale;

    var strings = this.pages[page];
    for (var string_id in strings) {
        var string = strings[string_id];
        var l10n_string = string[loc];
        if (!l10n_string) {
            l10n_string = string[this.default_locale];
        }
        $(string.selector).html(l10n_string);
    }

    if (!no_always) {
        for (var page in this.always_localize) {
            this.localize_page(this.always_localize[page], loc, true);
        }
    }

    return true;
},

/**
 * Localize entire all pages (may be slow)
 * @param custom_locale (optional) - custom locale codename
 */
localize_all_pages: function(custom_locale) {
    var loc = custom_locale || this.locale || this.default_locale;

    for (var page_name in this.pages) {
        this.localize_page(page_name, loc, true);
    }

    for (var page in this.always_localize) {
        this.localize_page(this.always_localize[page], loc, true);
    }

    return true;
},

/**
 * (private method) Returns localization object by string codename
 * @param name (required) - string codename
 * @param custom_page (optional) - page codename, if not provided causes full scan for string codename
 */
get_l10n_object: function(name, custom_page) {
    // If custom_page not provided start full search
    // until first occurrence of string codename
    var page = custom_page;
    if (!page) {
        var found = false;
        for (var page_name in this.pages) {
            var strings = this.pages[page_name];
            for (var string_id in strings) {
                if (string_id == name) {
                    page = page_name;
                    found = true;
                    break;
                }
            }
            if (found) break;
        }
    }

    return this.pages[page][name];
},

change_locale: function() {
    if ($('#select_language').val() == 'en')
    {
        document.cookie = "language=en; max-age=24*3600"
        //$('.language').removeClass("ru")
        //$('#language').text('en')
    }
    else if ($('#select_language').val() == 'ru')
    {
        document.cookie = "language=ru; max-age=24*3600"
        //$('.language').addClass("ru")
        //$('#language').text('ru')
    }
    location.reload()
},

show_locale: function() {
    
    var select = $('<select id="select_language">')
    select.append($('<option>').val("ru").text("Русский"))
    select.append($('<option>').val("en").text("English"))
    var button = $(`<input type="submit" onclick="l100n.change_locale()">`).val(l100n.localize_string("apply_button"))
    var form = $('<form>').append(select).append(button).addClass('apply_form')
    $('#language').append(form)

    if (get_cookie_locale() == "ru")
    {
        //$('.language').addClass("ru")
        
        $('#select_language').val('ru')
    }
    else
    {
        $('#select_language').val('en')
    }
}
}

function getCookie(name) {
	let matches = document.cookie.match(new RegExp(
	  "(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
	));
    return matches ? decodeURIComponent(matches[1]) : undefined
}

function get_cookie_locale()
{
    var locale = getCookie("language")
    if (locale == undefined)
    {
        locale = "en"
    }
    return locale
}

$(document).ready(function()
{           
    $.datepicker.regional['ru'] = {
        closeText: 'Закрыть',
        prevText: 'Предыдущий',
        nextText: 'Следующий',
        currentText: 'Сегодня',
        monthNames: ['Январь','Февраль','Март','Апрель','Май','Июнь','Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь'],
        monthNamesShort: ['Янв','Фев','Мар','Апр','Май','Июн','Июл','Авг','Сен','Окт','Ноя','Дек'],
        dayNames: ['воскресенье','понедельник','вторник','среда','четверг','пятница','суббота'],
        dayNamesShort: ['вск','пнд','втр','срд','чтв','птн','сбт'],
        dayNamesMin: ['Вс','Пн','Вт','Ср','Чт','Пт','Сб'],
        weekHeader: 'Не',
        dateFormat: 'yy-mm-dd',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };

    $.datepicker.regional['en'] = {
        dateFormat: 'yy-mm-dd',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };

    
    $.datepicker.setDefaults($.datepicker.regional[get_cookie_locale()])
})
